// Implementazione del Tipo di dati astratto "Lista"
// mediante una lista semplice (collegata in avanti)


package dlinklist;

class DoubleLList
{
  private int size;
  private DoubleListNode first, last;

  public DoubleLList () { first = null; last = null; size = 0;}


  // Inserimento di un oggetto all'inizio della lista
  public void insert(Object o)
  { DoubleListNode node = new DoubleListNode(o, this);
    node.setNext(first);
    node.setPrev(null);
    if(first!=null) first.setPrev(node);
    first = node;
    if(last==null) last = node;
    size++;
  }

  // Aggiunta di un oggetto alla fine della lista
  public void append(Object o)
  { DoubleListNode node = new DoubleListNode(o, this);
    node.setPrev(last);
    node.setNext(null);
    if(last!=null) last.setNext(node);
    last = node;
    if(first==null) first = node;
    size++;
  }

  // Rimozione del primo elemento della lista
  public Object removeFirst() throws ListException
  {
    if(isEmpty()) throw new ListException("lista vuota!");
    DoubleListNode node = first;
    first = node.getNext();
    if(first!=null)  first.setPrev(null);
    else last = null;
    size--;
    return node.getItem();
  }

  // Rimozione dell'ultimo elemento della lista
  public Object removeLast() throws ListException
  {
    if(isEmpty()) throw new ListException("lista vuota!");
    DoubleListNode node = last;
    last = node.getPrev();
    if(last!=null)  last.setNext(null);
    else first = null;
    size--;
    return node.getItem();
  }

  // Restituire il primo elemento della lista
  public Object first() throws ListException
  { if(isEmpty()) throw new ListException("lista vuota!");
    return first.getItem();
  }

  // Restituire l'ultimo elemento della lista
  public Object last() throws ListException
  { if(isEmpty()) throw new ListException("lista vuota!");
    return last.getItem();
  }

  // Numero di elementi nella lista:
  public int size()
  { return size;}

  // La lista  vuota?
  public boolean isEmpty()
  { return first==null;}

  public void insertInizioeFine 
     (Object oggetto1, Oggetto oggetto2) 
  {}
}



